//LidScrewThread.scad;

//Module to define one hole for the screw 
//that fastens the lid to the floor; 

//This module constructs the hole 
//as an object to be removed from the floor 
//by a difference() command;
    
//On output from this module, the hole object  
//is centered about the Z axis, 
//with the head resting on the XY plane, and
//the hole for the thread along the Z axis;

//Any further adjustment of orientation
//and/or position must be done 
//by the calling module;
    
//Warning!
//Because this object will be used in a 
//subsequent difference() command, 
//it isn't safe to make the thread longer
//than necessary and its length must be 
//reasonably accurate;

include <UNO_Dimensions.scad>;

module LidScrewThread(ThisHolePhi)
{

echo("Begin LidScrewThread");
    
cylinder(h=FloorZ +2*Fuzz,
    d=ThisHolePhi, center=false, $fn=32);

}

//
